/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.access;

import com.mojang.datafixers.util.Either;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.TriState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.coppergolem.CopperGolem;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.level.block.WeatheringCopper;
import snownee.jade.JadeClient;
import snownee.jade.addon.access.AccessibilityPlugin;
import snownee.jade.addon.access.EntityVariantHelper;
import snownee.jade.addon.core.ObjectNameProvider;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.JadeIds;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.util.CommonProxy;

public class EntityDetailsProvider
implements IEntityComponentProvider {
    @Override
    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        Either<String, Component> color;
        Mob mob;
        TriState shearable;
        LivingEntity livingEntity;
        CopperGolem golem;
        WeatheringCopper.WeatherState state;
        Goat goat;
        ZombieVillager zombieVillager;
        WitherBoss witherBoss;
        Creeper creeper;
        Entity entity = accessor.getEntity();
        String objectName = tooltip.getString(JadeIds.CORE_OBJECT_NAME);
        if (entity instanceof Creeper && (creeper = (Creeper)entity).isPowered()) {
            AccessibilityPlugin.replaceTitle(tooltip, objectName, "creeper.powered");
        } else if (entity instanceof WitherBoss && (witherBoss = (WitherBoss)entity).isPowered()) {
            AccessibilityPlugin.replaceTitle(tooltip, objectName, "wither.powered");
        } else if (entity instanceof ZombieVillager && (zombieVillager = (ZombieVillager)entity).isConverting()) {
            AccessibilityPlugin.replaceTitle(tooltip, objectName, "zombie_villager.curing");
        } else if (entity instanceof Goat && !(goat = (Goat)entity).hasLeftHorn() && !goat.hasRightHorn()) {
            AccessibilityPlugin.replaceTitle(tooltip, objectName, "goat.hornless");
        } else if (entity instanceof Bee) {
            Bee bee = (Bee)entity;
            if (bee.hasNectar()) {
                AccessibilityPlugin.replaceTitle(tooltip, objectName, "bee.nectar");
            }
            if (bee.isAngry()) {
                AccessibilityPlugin.replaceTitle(tooltip, objectName, "entity.angry");
            }
        } else if (entity instanceof Slime) {
            Slime slime = (Slime)entity;
            String message = tooltip.getString(JadeIds.CORE_OBJECT_NAME);
            MutableComponent title = IThemeHelper.get().title(JadeClient.format("jade.access.slime.size", message, slime.getSize()));
            tooltip.replace(JadeIds.CORE_OBJECT_NAME, (Component)title);
        } else if (entity instanceof CopperGolem && (state = (golem = (CopperGolem)entity).getWeatherState()) != WeatheringCopper.WeatherState.UNAFFECTED) {
            AccessibilityPlugin.replaceTitle(tooltip, objectName, "entity." + state.getSerializedName());
        }
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).isBaby()) {
            AccessibilityPlugin.replaceTitle(tooltip, objectName, "entity.baby");
        }
        if ((shearable = CommonProxy.isShearable(entity)) != TriState.DEFAULT) {
            if (entity instanceof CopperGolem) {
                if (shearable == TriState.TRUE) {
                    AccessibilityPlugin.replaceTitle(tooltip, objectName, "entity.shearable");
                }
            } else if (shearable == TriState.FALSE) {
                AccessibilityPlugin.replaceTitle(tooltip, objectName, "entity.sheared");
            }
        }
        if (entity instanceof Mob && (mob = (Mob)entity).isSaddled()) {
            AccessibilityPlugin.replaceTitle(tooltip, objectName, "entity.saddled");
        }
        if ((color = EntityVariantHelper.getVariantName(entity, true)) != null) {
            color.ifLeft(s -> AccessibilityPlugin.replaceTitle(tooltip, objectName, "entity." + s));
        }
    }

    @Override
    public ResourceLocation getUid() {
        return JadeIds.ACCESS_ENTITY_DETAILS;
    }

    @Override
    public int getDefaultPriority() {
        return ObjectNameProvider.ForEntity.INSTANCE.getDefaultPriority() + 10;
    }
}

